/*
 * Modified by Stephen H.L.Wang
 *
 * version 0.2alpha - 12/29/1997
 */

#ifndef _MXIC_REG_H
#define _MXIC_REG_H

#include <Xmd.h>

#define int8	CARD8
#define int16	CARD16
#define int32	CARD32

#ifndef DWORD
#define DWORD   int32
#endif

#define MX25x_SPRITE_H_START_LO     0x0060
#define MX25x_SPRITE_H_START_HI     0x0061
#define MX25x_SPRITE_H_PRESET       0x0062
#define MX25x_SPRITE_V_START_LO     0x0063
#define MX25x_SPRITE_V_START_HI     0x0064
#define MX25x_SPRITE_V_PRESET       0x0065
#define MX25x_SPRITE_CONTROL        0x0066
#define MX25x_SPRITE_COLOR0_RED     0x0067
#define MX25x_SPRITE_COLOR0_GREEN   0x0068
#define MX25x_SPRITE_COLOR0_BLUE    0x0069
#define MX25x_SPRITE_COLOR1_RED     0x006A
#define MX25x_SPRITE_COLOR1_GREEN   0x006B
#define MX25x_SPRITE_COLOR1_BLUE    0x006C

#ifdef DBG
#define SPRITE_COLOR0_RED           0x0000
#define SPRITE_COLOR0_GREEN         0x0000
#define SPRITE_COLOR0_BLUE          0x0000
#define SPRITE_COLOR1_RED           0x0005    /* for 256 color,color 1 is red */
#define SPRITE_COLOR1_GREEN         0x0000    /* for 64K color,color 1 is green */
#define SPRITE_COLOR1_BLUE          0x00FF    /* for true color,color 1 is blue */
#else
#define SPRITE_COLOR0_RED           0x0000
#define SPRITE_COLOR0_GREEN         0x0000
#define SPRITE_COLOR0_BLUE          0x0000
#define SPRITE_COLOR1_RED           0x00FF
#define SPRITE_COLOR1_GREEN         0x00FF
#define SPRITE_COLOR1_BLUE          0x00FF
#endif

#define COPScrFormat            0x0000
#define COPBaseAddr             0x0000
#define COPBppFormat            0x0001
#define COPScreenWidth          0x0003
                                
#define COPB2OPWidth            0x0010
#define COPB2ET                 0x0012
#define COPB2K1                 0x0014
#define COPB2K2                 0x0016
                                
#define COPMaskReg              0x0058
#define COPClipX1               0x005C
#define COPClipY1               0x005E
#define COPClipX2               0x0060
#define COPClipY2               0x0062
                                
#define COPColorCmp             0x0064
#define COPFGColor              0x0068
#define COPBGColor              0x006C
#define COPXSrcOrg              0x0070
#define COPYSrcOrg              0x0072
#define COPXDstOrg              0x0074
#define COPYDstOrg              0x0076
#define COPOpWidth              0x0078
#define COPOpHeight             0x007A
#define COPPixelOp              0x007C
                                
#define COPState                0x0080
                                
#define COPB1K1                 0x0070
#define COPB1k2                 0x0072
#define COPB1OPWidth            0x0078
#define COPB1ET                 0x007A
                                
#define COPB2XDstOrg            0x0094
                                
#define COPPATBase              0x0100
#define COPScrPort              0x8000
                                
#define COPBusy                 0x0080
#define COPStop                 0x0020
#define COPFIFONotEmpty		0x0040
                                
#define SelPatMapFlag           0x0080

/* PACKXY(x,y) pack word x and word y to be : y in high word, x in low word */
#define PACKXY(x, y)            (((DWORD)(y) << 16) | ((DWORD)(x) & 0x0000ffffL))

/* Destination Screen Format bits (REG 0) */
#define COPPIXEL8BPP            0x00000000
#define COPPIXEL16BPP           0x00000100
#define COPPIXEL15BPP           0x00000200
#define COPPIXEL15BPP0          0x00000300
#define COPPIXEL32BPP           0x00000400
#define COPPIXEL24BPP           0x00000500  /* illegel */

#define COPSCRWIDTH640          0x00000000
#define COPSCRWIDTH800          0x01000000
#define COPSCRWIDTH1024         0x02000000
#define COPSCRWIDTH1152         0x03000000
#define COPSCRWIDTH1280         0x04000000
#define COPSCRWIDTH1600         0x05000000
#define COPSCRWIDTH2048         0x06000000

/* POR bit constant definition */
#define OP_NOP                  0

#define ALIGN_SIZE_16           0x80000000L
#define ALIGN_SIZE_32           0

#define AUTOEXEC_ENABLE         0x40000000L
#define AUTOEXEC_DISABLE        0

#define OP_BITBLT               0x08000000L
#define OP_LINE                 0x05000000L

#define FIRSTSET_PATTERN        0
#define SECONDSET_PATTERN       0x00800000L
#define PATTERNMAP_COLOR        0
#define PATTERNMAP_MONO         0x00400000L

#define SOURCEMAP_COLOR         0x00100000L
#define SOURCEMAP_FGCOLOR       0x00200000L
#define SOURCEMAP_MONO          0x00300000L

#define BITBLT_SCN2SCN          0
#define BITBLT_MEM2SCN          0x00040000L
#define BITBLT_SCN2MEM          0x00080000L

#define COLORCMP_DISABLE        0
#define COLORCMP_UPDATE_EQ      0x00010000L
#define COLORCMP_UPDATE_NE      0x00020000L

#define CMPCOLOR_DST            0x00000080L
#define CMPCOLOR_SRC            0

#define CLIP_ENABLE             0x00000040L
#define CLIP_DISABLE            0

#define LAST_PIXEL_ON           0
#define LAST_PIXEL_OFF          0x00000020L

/* CMD_xxx defines mirror bit to S3V */
#define CMD_BITBLT              OP_BITBLT
#define CMD_LINE                OP_LINE
/* #define CMD_AUTOEXEC            AUTOEXEC_ENABLE */
#define CMD_AUTOEXEC            0
#define CMD_HWCLIP              CLIP_ENABLE
#define CMD_XP                  0x00000004L
#define CMD_YP                  0x00000002L
#define CMD_ITA_DWORD           0
#define MIX_MONO_PATT           PATTERNMAP_MONO
#define MIX_COLOR_PATT          PATTERNMAP_COLOR
#define MIX_CPUDATA             BITBLT_MEM2SCN
#define MIX_MONO_SRC            SOURCEMAP_MONO
#define MIX_MONO_TRANSP         (COLORCMP_UPDATE_NE|CMPCOLOR_SRC)

/* Memory-mapped I/O register accessing macros */

#define MMIO_WORD(ppdev, pjMmBase, reg, val)      (*(WORD *)((DWORD)pjMmBase+reg) = (WORD)(val))
#define MMIO_DWORD(ppdev, pjMmBase, reg, val)     (*(DWORD *)((DWORD)pjMmBase+reg) = (DWORD)(val))

#define MMIO_SCR_FMT(ppdev, pjMmBase, v)  (*(DWORD *)((DWORD)pjMmBase+COPScrFormat) = (DWORD)(v))

#define MMIO_SRC_X(ppdev, pjMmBase, x)    (*(WORD *)((DWORD)pjMmBase+COPXSrcOrg) = (WORD)(x))
#define MMIO_SRC_Y(ppdev, pjMmBase, y)    (*(WORD *)((DWORD)pjMmBase+COPYSrcOrg) = (WORD)(y))
#define MMIO_DST_X(ppdev, pjMmBase, x)    (*(WORD *)((DWORD)pjMmBase+COPXDstOrg) = (WORD)(x))
#define MMIO_DST_Y(ppdev, pjMmBase, y)    (*(WORD *)((DWORD)pjMmBase+COPYDstOrg) = (WORD)(y))

#define MMIO_SRC_POS(ppdev, pjMmBase, yx) (*(DWORD *)((DWORD)pjMmBase+COPXSrcOrg) = (DWORD)(yx))
#define MMIO_DST_POS(ppdev, pjMmBase, yx) (*(DWORD *)((DWORD)pjMmBase+COPXDstOrg) = (DWORD)(yx))

#define MMIO_LINE_K1(ppdev, pjMmBase, k)  (*(WORD *)((DWORD)pjMmBase+COPB1K1) = (WORD)(k))
#define MMIO_LINE_K2(ppdev, pjMmBase, k)  (*(WORD *)((DWORD)pjMmBase+COPB1K2) = (WORD)(k))
#define MMIO_LINE_ET(ppdev, pjMmBase, et) (*(WORD *)((DWORD)pjMmBase+COPB1ET) = (WORD)(et))

#define MMIO_LINE_K1K2(ppdev, pjMmBase, k1, k2)  (*(DWORD *)((DWORD)pjMmBase+COPB1K1) = (DWORD)(PACKXY((k1),(k2))))

#define MMIO_HOR_AXIS_PCNT(ppdev, pjMmBase, cxGlyph)      (*(WORD *)((DWORD)pjMmBase+COPOpWidth) = (WORD)(cxGlyph))
#define MMIO_VER_AXIS_PCNT(ppdev, pjMmBase, cyGlyph)      (*(WORD *)((DWORD)pjMmBase+COPOpHeight) = (WORD)(cyGlyph))

#define MMIO_AXIS_PCNT(ppdev, pjMmBase, yx)               (*(DWORD *)((DWORD)pjMmBase+COPOpWidth) = (DWORD)(yx))

#define MMIO_COP_COLOR_LA(ppdev, linearaddr, Color)                             \
{                                                                               \
    if (ppdev->ulBitCount == 8)                                                 \
    {                                                                           \
        (*(DWORD *)(linearaddr) = ((DWORD)(Color) + ((DWORD)(Color)<<8)));      \
    }                                                                           \
    else                                                                        \
    {                                                                           \
        (*(DWORD *)(linearaddr) = (DWORD)(Color));                              \
    }                                                                           \
}


#define MMIO_FG_COLOR(ppdev, pjMmBase, Color)     MMIO_COP_COLOR_LA(ppdev, (DWORD)pjMmBase+COPFGColor, Color)
#define MMIO_BG_COLOR(ppdev, pjMmBase, Color)     MMIO_COP_COLOR_LA(ppdev, (DWORD)pjMmBase+COPBGColor, Color)
#define MMIO_CMP_COLOR(ppdev, pjMmBase, Color)    MMIO_COP_COLOR_LA(ppdev, (DWORD)pjMmBase+COPColorCmp, Color)

#define MMIO_SCISSORS_L(ppdev, pjMmBase, xLeft)   (*(WORD *)((DWORD)pjMmBase+COPClipX1) = (WORD)(xLeft))
#define MMIO_SCISSORS_R(ppdev, pjMmBase, xRight)  (*(WORD *)((DWORD)pjMmBase+COPClipX2) = (WORD)(xRight))
#define MMIO_SCISSORS_T(ppdev, pjMmBase, xTop)    (*(WORD *)((DWORD)pjMmBase+COPClipY1) = (WORD)(xTop))
#define MMIO_SCISSORS_B(ppdev, pjMmBase, xBottom) (*(WORD *)((DWORD)pjMmBase+COPClipY2) = (WORD)(xBottom))

#define MMIO_SCISSORS_MIN(ppdev, pjMmBase, yx)    (*(DWORD *)((DWORD)pjMmBase+COPClipX1) = (DWORD)(yx))
#define MMIO_SCISSORS_MAX(ppdev, pjMmBase, yx)    (*(DWORD *)((DWORD)pjMmBase+COPClipX2) = (DWORD)(yx))

#define MMIO_CMD(ppdev, pjMmBase, cmd)            (*(DWORD *)((DWORD)pjMmBase+COPPixelOp) = (DWORD)(cmd))

#define MMIO_GET_DATAPORT(ppdev, pjMmBase)        ((DWORD *)((DWORD)pjMmBase+COPScrPort))

#define MMIO_DATA_DWORD(ppdev, pjMmBase, val)     (*(DWORD *)((DWORD)pjMmBase+COPScrPort) = (DWORD)(val))
#define MMIO_DATA_DWORD_LA(ppdev, linearaddr, val) (*(DWORD *)(linearaddr) = (DWORD)(val))

#define MMIO_TRANSFER_BYTE(ppdev, pjMmBase, p, c)                           \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcw        = (c) >> 1;                                        \
    DWORD    _tmpdw;                                                        \
                                                                            \
    ASSERTDD((c) > 0, "Can't have a zero transfer count");                  \
                                                                            \
    while (_mcw-- != 0)                                                     \
    {                                                                       \
        _tmpdw = ((DWORD)*_mpjSrc) | (((DWORD)*(_mpjSrc+1)) << 16);         \
        MMIO_DATA_DWORD_LA(ppdev, _mpjDst, _tmpdw);                         \
        _mpjSrc += 2;                                                       \
    }                                                                       \
    if ((c) & 1)                                                            \
    {                                                                       \
        MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (DWORD)(*_mpjSrc));              \
    }                                                                       \
}                                                                           

#define MMIO_TRANSFER_3BYTE(ppdev, pjMmBase, p, cy)                         \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcy        = (cy);                                            \
                                                                            \
    ASSERTDD(((cy) > 0), "Can't have a zero transfer count");               \
                                                                            \
    while (_mcy-- != 0)                                                     \
    {                                                                       \
        MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));            \
        _mpjSrc += 3;                                                       \
    }                                                                       \
}

#define MMIO_TRANSFER_WORD(ppdev, pjMmBase, p, c)                           \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcd        = (c) >> 2;                                        \
                                                                            \
    ASSERTDD((c) > 0, "Can't have a zero transfer count");                  \
    ASSERTDD(((c)&1)==0, "Can't have an odd number transfer count");        \
                                                                            \
    while (_mcd-- != 0)                                                     \
    {                                                                       \
        MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));            \
        _mpjSrc += 4;                                                       \
    }                                                                       \
    if ((c) & 2)                                                            \
    {                                                                       \
        MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(WORD *)_mpjSrc));             \
    }                                                                       \
}

#define MMIO_TRANSFER_WORD_EVEN(ppdev, pjMmBase, p, cjWidth, cy)            \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcy        = (cy);                                            \
    LONG     _mcd        = (cjWidth) >> 2;                                  \
    LONG     _mc;                                                           \
                                                                            \
    ASSERTDD(((cjWidth)>=6)&&((cy)>0), "Can't have a zero transfer count"); \
    ASSERTDD(((cjWidth)&1)==0, "Can't have an odd number transfer count");  \
                                                                            \
    if (_mcd > 1)                                                           \
    {                                                                       \
        while (_mcy-- != 0)                                                 \
        {                                                                   \
            _mc = _mcd;                                                     \
            while (_mc-- != 0)                                              \
            {                                                               \
                MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));    \
                _mpjSrc += 4;                                               \
            }                                                               \
                                                                            \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(WORD *)_mpjSrc));         \
            _mpjSrc += 2;                                                   \
        }                                                                   \
    }                                                                       \
    else                                                                    \
    {                                                                       \
        while (_mcy-- != 0)                                                 \
        {                                                                   \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));        \
            _mpjSrc += 4;                                                   \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(WORD *)_mpjSrc));         \
            _mpjSrc += 2;                                                   \
        }                                                                   \
    }                                                                       \
}

#define MMIO_TRANSFER_WORD_1ODD(ppdev, pjMmBase, p, cjWidth, cy)            \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcy        = (cy);                                            \
    LONG     _mcd        = ((cjWidth) >> 2);                                \
    LONG     _mc;                                                           \
                                                                            \
    ASSERTDD(((cjWidth)>=5) && ((cy)>0), "Can't have a zero transfer count"); \
    ASSERTDD(((cjWidth) & 3)==1, "Must be odd byte width");                 \
                                                                            \
    if (_mcd > 1)                                                           \
    {                                                                       \
        while (_mcy-- != 0)                                                 \
        {                                                                   \
            _mc = _mcd;                                                     \
            while (_mc-- != 0)                                              \
            {                                                               \
                MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));    \
                _mpjSrc += 4;                                               \
            }                                                               \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (DWORD)(*_mpjSrc));          \
            _mpjSrc += 1;                                                   \
        }                                                                   \
    }                                                                       \
    else                                                                    \
    {                                                                       \
        while (_mcy-- != 0)                                                 \
        {                                                                   \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));        \
            _mpjSrc += 4;                                                   \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (DWORD)(*_mpjSrc));          \
            _mpjSrc += 1;                                                   \
        }                                                                   \
    }                                                                       \
}

#define MMIO_TRANSFER_WORD_3ODD(ppdev, pjMmBase, p, cjWidth, cy)            \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcy        = (cy);                                            \
    LONG     _mcd        = (cjWidth) >> 2;                                  \
    LONG     _mc;                                                           \
                                                                            \
    ASSERTDD(((cjWidth)>=7) && ((cy)>0), "Can't have a zero transfer count");\
    ASSERTDD(((cjWidth) & 3)==3, "Must be odd byte width");                 \
                                                                            \
    if (_mcd > 1)                                                           \
    {                                                                       \
        while (_mcy-- != 0)                                                 \
        {                                                                   \
            _mc = _mcd;                                                     \
            while (_mc-- != 0)                                              \
            {                                                               \
                MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));    \
                _mpjSrc += 4;                                               \
            }                                                               \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));        \
            _mpjSrc += 3;                                                   \
        }                                                                   \
    }                                                                       \
    else                                                                    \
    {                                                                       \
        while (_mcy-- != 0)                                                 \
        {                                                                   \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));        \
            _mpjSrc += 4;                                                   \
            MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));        \
            _mpjSrc += 3;                                                   \
        }                                                                   \
    }                                                                       \
}

#define MMIO_TRANSFER_DWORD(ppdev, pjMmBase, p, c)                          \
{                                                                           \
    BYTE*    _mpjSrc     = (BYTE*) (p);                                     \
    DWORD*   _mpjDst     = MMIO_GET_DATAPORT(ppdev, pjMmBase);              \
    LONG     _mcd        = (c) >> 2;                                        \
                                                                            \
    ASSERTDD((c) > 0, "Can't have a zero transfer count");                  \
                                                                            \
    while (_mcd-- != 0)                                                     \
    {                                                                       \
        MMIO_DATA_DWORD_LA(ppdev, _mpjDst, (*(DWORD *)_mpjSrc));            \
        _mpjSrc += 4;                                                       \
    }                                                                       \
}

#define OUTPW(p, v)   outw((p), (v))
#define OUTP(p, v)    outb((p), (v))
#define INPW(p)       inw(p)
#define INP(p)        inb(p)

#define CRTC_INDEX                      0x03D4
#define CRTC_DATA                       0x03D5

#define SYSTEM_CONTROL_REG              0x25
#define VP_POWERDOWN                    0x02
#define VP_NOTRESET                     0x10

#define MEMORY_TYPE_REG                 0x30
#define MEMORY_TYPE_BIT_MASK            0x30
#define MEMORY_TYPE_BIT_SHIFT           4

#define STATUS_1                        0x03DA
#define DISPLAY_MODE_INACTIVE           0x001
#define VBLANK_ACTIVE                   0x008

#define RGB15to32(c) \
        (((c & 0x7c00) << 9) | \
         ((c & 0x03e0) << 6) | \
         ((c & 0x001f) << 3))

#define RGB16to32(c) \
        (((c & 0xf800) << 8) | \
         ((c & 0x07e0) << 5) | \
         ((c & 0x001f) << 3))

#define VBLANK_IS_ACTIVE \
    (INP(STATUS_1) & VBLANK_ACTIVE)

#define DISPLAY_IS_ACTIVE \
    (!(INP(STATUS_1) & DISPLAY_MODE_INACTIVE))

#define WAIT_FOR_VBLANK \
    while (!(VBLANK_IS_ACTIVE));

#define WAIT_FOR_VBLANK_START    \
    while (VBLANK_IS_ACTIVE);    \
    while (!(VBLANK_IS_ACTIVE));


#define VerticalRetraceWait() \
{ \
   outb(vgaCRIndex, 0x17); \
   if ( inb(vgaCRReg) & 0x80 ) { \
       while ((inb(vgaIOBase + 0x0A) & 0x08) == 0x00) ; \
       while ((inb(vgaIOBase + 0x0A) & 0x08) == 0x08) ; \
       while ((inb(vgaIOBase + 0x0A) & 0x08) == 0x00) ; \
       }\
}

/* Various defines which are used to pass flags between the Setup and 
 * Subsequent functions. 
 */

#define NO_MONO_FILL      0x00
#define NEED_MONO_FILL    0x01
#define MONO_TRANSPARENCY 0x02


static __inline__ int MXICCheckBltWidth(int w)
{
   return w;
}

static __inline__ int MXICCheckLSPN(int w, int n)
{
   return w;
}

/* This next function determines if the Source operand is present in the
 * given ROP. The rule is that both the lower and upper nibble of the rop
 * have to be neither 0x00, 0x05, 0x0a or 0x0f. If a CPU-Screen blit is done
 * with a ROP which does not contain the source, the virge will hang when
 * data is written to the image transfer area. 
 */

static __inline__ Bool MXICROPHasSrc(shifted_rop)
int shifted_rop;
{
    int rop = (shifted_rop & (0xff << 8)) >> 8;

    if ((((rop & 0x0f) == 0x0a) | ((rop & 0x0f) == 0x0f) 
        | ((rop & 0x0f) == 0x05) | ((rop & 0x0f) == 0x00)) &
       (((rop & 0xf0) == 0xa0) | ((rop & 0xf0) == 0xf0) 
        | ((rop & 0xf0) == 0x50) | ((rop & 0xf0) == 0x00)))
            return FALSE;
    else 
            return TRUE;
}

/* This next function determines if the Destination operand is present in the
 * given ROP. The rule is that both the lower and upper nibble of the rop
 * have to be neither 0x00, 0x03, 0x0c or 0x0f. 
 */

static __inline__ Bool MXICROPHasDst(int shifted_rop)
{
    int rop = (shifted_rop & (0xff << 8)) >> 8;

    if ((((rop & 0x0f) == 0x0c) | ((rop & 0x0f) == 0x0f) 
        | ((rop & 0x0f) == 0x03) | ((rop & 0x0f) == 0x00)) &
       (((rop & 0xf0) == 0xc0) | ((rop & 0xf0) == 0xf0) 
        | ((rop & 0xf0) == 0x30) | ((rop & 0xf0) == 0x00)))
            return FALSE;
    else 
            return TRUE;
}

typedef struct { int16 vendor_ID; int16 device_ID; } pci_id;
typedef struct { int16 cmd; int16 devsel; } cmd_devsel;

typedef struct  {
        pci_id  pci_ident;
        cmd_devsel cmd_device_sel;
        int32 class_code;
        char  dummy_0c;
	char  latnecy_timer;
	int16 dummy_0e;
        int32 base0;
        char  dummy_14[0x20-sizeof(int32)];
        int32 bios_base;
	int32 dummy_34;
	int32 dummy_38;
        char  int_line;
        char  int_pin;
        int16  latency_grant;
} pci_conf_regs;

typedef struct  {
   char   filler1[0x100];
   int8   patt1[0x80];
   int8   patt2[0x80];
} _colpatt_regs;

typedef struct  {
   int32  scr_fmt;
   int32  dest_src_str;
   int32  src_base;
   int32  dest_base;
   char   filler1[0x58-0x10];
   int32  clr_cmp_mask;
   int32  clip_t_l;
   int32  clip_b_r;
   int32  clr_cmp_clr;
   int32  srcpat_fg_clr;
   int32  srcpat_bg_clr;
   int32  rsrc_yx;
   int32  rdest_yx;
   int32  rheight_width;
   int32  cmd_set;
} _bltfill_regs;

typedef struct  {
   int32  scr_fmt;
   int32  dest_src_str;
   int32  src_base;
   int32  dest_base;
   char   filler1[0x58-0x10];
   int32  clr_cmp_mask;
   int32  clip_t_l;
   int32  clip_b_r;
   int32  clr_cmp_clr;
   int32  srcpat_fg_clr;
   int32  srcpat_bg_clr;
   int32  k2k1;
   union {
       int32  rdest_yx;
       struct {
           int16 lxstart;
	   int16 lystart;
       } w;
   } xy;
   int16  rwidth;
   int16  et;
   int32  cmd_set;
} _line_regs;

typedef struct {
   char   filler1[0x80];
   int32  state;
} _COPstate_regs;

typedef struct {
   int32 copregs[0x100/sizeof(int32)];
   int32 patt1[0x80/sizeof(int32)];
   int32 patt2[0x80/sizeof(int32)];
   int32 videoregs[0x100/sizeof(int32)];
   int32 mpregs[0x100/sizeof(int32)];
   char  filler1[0x8000-0x400];
   int32 scrport[0x8000/sizeof(int32)];
} _dw_regs;   

typedef union {
   int32	   img[0x10000/sizeof(int32)];
   int32           scr_fmt;
   _dw_regs	   dw_regs;
   _colpatt_regs   colpatt_regs;
   _bltfill_regs   bltfill_regs;
   _line_regs      line_regs;
   _COPstate_regs  COPstate_regs;
} mm_mx8625x_regs ;

#define mmtr	volatile mm_mx8625x_regs *

/* VESA Approved Register Definitions */
#define	DAC_MASK	0x03c6
#define	DAC_R_INDEX	0x03c7
#define	DAC_W_INDEX	0x03c8
#define	DAC_DATA	0x03c9

#define SET_DAC_W_INDEX(index)  outb(DAC_W_INDEX, index)
#define SET_DAC_DATA(val) 	outb(DAC_DATA,val)

#define IMG_TRANS		((((mmtr)mxicMmioMem)->dw_regs).scrport)
#define SET_PIXTRANS(a,v)	IMG_TRANS[a] = (v)
#define COLOR_PATTERN0          (((mmtr)mxicMmioMem)->colpatt_regs.patt1)
#define COLOR_PATTERN1          (((mmtr)mxicMmioMem)->colpatt_regs.patt2)
#define MONO_PATTERN0          (((mmtr)mxicMmioMem)->colpatt_regs.patt1)
#define MONO_PATTERN1          (((mmtr)mxicMmioMem)->colpatt_regs.patt2)
#define COLOR_PATTERN0dw        (((mmtr)mxicMmioMem)->dw_regs.patt1)
#define COLOR_PATTERN1dw        (((mmtr)mxicMmioMem)->dw_regs.patt2)
#define MONO_PATTERN0dw         (((mmtr)mxicMmioMem)->dw_regs.patt1)
#define MONO_PATTERN1dw         (((mmtr)mxicMmioMem)->dw_regs.patt2)

#define SET_SCR_FMT(val)	((mmtr)mxicMmioMem)->scr_fmt = (val)

#define SETB_SRC_BASE(val)	((mmtr)mxicMmioMem)->bltfill_regs.src_base = (val)
#define SETB_DEST_BASE(val)	((mmtr)mxicMmioMem)->bltfill_regs.dest_base = (val)
#define SETB_CLIP_L_T(l,t)	((mmtr)mxicMmioMem)->bltfill_regs.clip_t_l = ((t)<<16 | (l))
#define SETB_CLIP_R_B(r,b)	((mmtr)mxicMmioMem)->bltfill_regs.clip_b_r = ((b)<<16 | (r))
#define SETB_CLIP_L_R(l,r)	do { unsigned int clip = ((mmtr)mxicMmioMem)->bltfill_regs.clip_t_l & 0xffff0000;  clip |= l; ((mmtr)mxicMmioMem)->bltfill_regs.clip_t_l = clip; clip = ((mmtr)mxicMmioMem)->bltfill_regs.clip_b_r & 0xffff0000;  clip |= r; ((mmtr)mxicMmioMem)->bltfill_regs.clip_b_r = clip; } while(0)
#define SETB_DEST_SRC_STR(d,s)	((mmtr)mxicMmioMem)->bltfill_regs.dest_src_str = ((d)<<16 | (s))
#define SETB_PAT_BG_CLR(val)	((mmtr)mxicMmioMem)->bltfill_regs.srcpat_bg_clr = (val)
#define SETB_PAT_FG_CLR(val)	((mmtr)mxicMmioMem)->bltfill_regs.srcpat_fg_clr = (val)
#define SETB_SRC_BG_CLR(val)	((mmtr)mxicMmioMem)->bltfill_regs.srcpat_bg_clr = (val)
#define SETB_SRC_FG_CLR(val)	((mmtr)mxicMmioMem)->bltfill_regs.srcpat_fg_clr = (val)
/*#define SETB_CMD_SET(val)	do { write_mem_barrier(); ((mmtr)mxicMmioMem)->bltfill_regs.cmd_set = (val); write_mem_barrier(); } while (0)*/
#define SETB_CMD_SET(val)	((mmtr)mxicMmioMem)->bltfill_regs.cmd_set = (val)
#define SETB_RWIDTH_HEIGHT(w,h)	((mmtr)mxicMmioMem)->bltfill_regs.rheight_width = ((h)<<16 | (w))
#define SETB_RSRC_XY(x,y)	((mmtr)mxicMmioMem)->bltfill_regs.rsrc_yx = ((y)<<16 | (x))
/*#define SETB_RDEST_XY(x,y)	do { write_mem_barrier(); ((mmtr)mxicMmioMem)->bltfill_regs.rdest_yx = ((y)<<16 | (x)); write_mem_barrier(); } while (0)*/
#define SETB_RDEST_XY(x,y)	((mmtr)mxicMmioMem)->bltfill_regs.rdest_yx = ((y)<<16 | (x))

#define SETB_MONO_PAT0(val)
#define SETB_MONO_PAT1(val)

#define SETB_CLRCMP_MASK(val)	((mmtr)mxicMmioMem)->bltfill_regs.clr_cmp_mask = (val)
#define SETB_CLRCMP_CLR(val)	((mmtr)mxicMmioMem)->bltfill_regs.clr_cmp_clr = (val)

/* Caching version of the same MACROs */

#define CACHE_SETB_CLIP_L_T(l,t)	do { unsigned int clip = ((t)<<16 | (l)); if (mxicCached_CLIP_TL != clip) { ((mmtr)mxicMmioMem)->bltfill_regs.clip_t_l = clip; mxicCached_CLIP_TL = clip; mxicCacheMiss++;} else mxicCacheHit++;} while(0)
#define CACHE_SETB_CLIP_R_B(r,b)	do { unsigned int clip = ((b)<<16 | (r)); if (mxicCached_CLIP_BR != clip) { ((mmtr)mxicMmioMem)->bltfill_regs.clip_b_r = clip; mxicCached_CLIP_BR = clip; mxicCacheMiss++;} else mxicCacheHit++;} while(0)
#define CACHE_SETB_CLIP_L_R(l,r)	do { unsigned int clip = (mxicCached_CLIP_TL & 0xffff0000) | l; ((mmtr)mxicMmioMem)->bltfill_regs.clip_t_l = mxicCached_CLIP_TL = clip; clip = (mxicCached_CLIP_BR & 0xffff0000) | r; ((mmtr)mxicMmioMem)->bltfill_regs.clip_b_r = mxicCached_CLIP_BR = clip; } while(0)
#define CACHE_SETB_RSRC_XY(x,y)		do { unsigned int src = ((y)<<16 | (x)); if (mxicCached_RSRC_XY != src) { ((mmtr)mxicMmioMem)->bltfill_regs.rsrc_yx = src; mxicCached_RSRC_XY = src; mxicCacheMiss++;} else mxicCacheHit++;} while(0)
#define CACHE_SETB_RWIDTH_HEIGHT(w,h)	do { unsigned int rwh = ((h)<<16 | (w)); if (mxicCached_RWIDTH_HEIGHT != rwh) { ((mmtr)mxicMmioMem)->bltfill_regs.rheight_width = rwh; mxicCached_RWIDTH_HEIGHT = rwh; mxicCacheMiss++;} else mxicCacheHit++;} while(0)
#define CACHE_SETB_PAT_FG_CLR(val)	do { if (mxicCached_PAT_FGCLR != val) { ((mmtr)mxicMmioMem)->bltfill_regs.srcpat_fg_clr = val; mxicCached_PAT_FGCLR = val; mxicCacheMiss++;} else mxicCacheHit++;} while(0)
#define CACHE_SETB_PAT_BG_CLR(val)	do { if (mxicCached_PAT_BGCLR != val) { ((mmtr)mxicMmioMem)->bltfill_regs.srcpat_bg_clr = val; mxicCached_PAT_BGCLR = val; mxicCacheMiss++;} else mxicCacheHit++;} while(0)
#define CACHE_SETB_CMD_SET(val)		do { if (mxicCached_CMD_SET != val) { write_mem_barrier(); ((mmtr)mxicMmioMem)->bltfill_regs.cmd_set = val; mxicCached_CMD_SET = val; mxicCacheMiss++; write_mem_barrier(); } else mxicCacheHit++;} while(0)

#define CACHE_SETB_MONO_PAT0(val)	do { /* if (mxicCached_MONO_PATTERN0 != val) { ((mmtr)mxicMmioMem)->bltfill_regs.mono_pat0 = val; mxicCached_MONO_PATTERN0 = val; mxicCacheMiss++;} else mxicCacheHit++; */} while(0)
#define CACHE_SETB_MONO_PAT1(val)	do { /* if (mxicCached_MONO_PATTERN1 != val) { ((mmtr)mxicMmioMem)->bltfill_regs.mono_pat1 = val; mxicCached_MONO_PATTERN1 = val; mxicCacheMiss++;} else mxicCacheHit++; */} while(0)

#define SETL_SRC_BASE(val)	((mmtr)mxicMmioMem)->line_regs.src_base = (val)
#define SETL_DEST_BASE(val)	((mmtr)mxicMmioMem)->line_regs.dest_base = (val)
#define SETL_CLIP_L_T(l,t)	((mmtr)mxicMmioMem)->line_regs.clip_t_l = ((t)<<16 | (l))
#define SETL_CLIP_R_B(r,b)	((mmtr)mxicMmioMem)->line_regs.clip_b_r = ((b)<<16 | (r))
#define SETL_DEST_SRC_STR(d,s)	((mmtr)mxicMmioMem)->line_regs.dest_src_str = ((d)<<16 | (s))
#define SETL_PAT_FG_CLR(val)	((mmtr)mxicMmioMem)->line_regs.srcpat_fg_clr = (val)
#define SETL_RWIDTH(val)	do { write_mem_barrier(); ((mmtr)mxicMmioMem)->line_regs.rwidth = (val); write_mem_barrier(); } while (0)
#define SETL_RDEST_XY(x,y)	do { write_mem_barrier(); ((mmtr)mxicMmioMem)->line_regs.xy.rdest_yx = ((y)<<16 | (x)); write_mem_barrier(); } while (0)
#define SETL_LXSTART(val)	((mmtr)mxicMmioMem)->line_regs.xy.w.lxstart = (val)
#define SETL_LYSTART(val)	((mmtr)mxicMmioMem)->line_regs.xy.w.lystart = (val)
#define SETL_K1K2ET(k1,k2,et)	do { ((mmtr)mxicMmioMem)->line_regs.k2k1 = ((k2)<<16) | (k1); ((mmtr)mxicMmioMem)->line_regs.et = et; } while (0)
#define SETL_CMD_SET(val)	do { write_mem_barrier(); ((mmtr)mxicMmioMem)->line_regs.cmd_set = (val); write_mem_barrier(); } while (0)

/* Cache version */
#define CACHE_SETL_CMD_SET(val)		do { if (mxicCached_CMD_SET != val) { write_mem_barrier(); ((mmtr)mxicMmioMem)->line_regs.cmd_set = val; mxicCached_CMD_SET = val; mxicCacheMiss++; write_mem_barrier(); } else mxicCacheHit++;} while(0)


typedef struct {
   unsigned char r, g, b;
} LUTENTRY;

/* Wait until "v" queue entries are free */
#define	WaitQueue(v)

/* Wait until GP is idle */
#define WaitIdle()		do { while (((mmtr)mxicMmioMem)->COPstate_regs.state & COPBusy); } while (0)

/* Wait until GP is idle and queue is empty */
#define	WaitIdleEmpty()		WaitIdle()

/* Wait until Command FIFO is empty */
/* #define WaitCommandEmpty() 	do { while (((mmtr)mxicMmioMem)->COPstate_regs.state & COPFIFONotEmpty); } while (0) */
#define WaitCommandEmpty()

#endif


